/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.util.internal;

import com.charles445.simpledifficulty.api.SDCapabilities;
import com.charles445.simpledifficulty.api.SDFluids;
import com.charles445.simpledifficulty.api.SDPotions;
import com.charles445.simpledifficulty.api.config.QuickConfig;
import com.charles445.simpledifficulty.api.config.ServerConfig;
import com.charles445.simpledifficulty.api.config.ServerOptions;
import com.charles445.simpledifficulty.api.thirst.IThirstCapability;
import com.charles445.simpledifficulty.api.thirst.IThirstUtil;
import com.charles445.simpledifficulty.api.thirst.ThirstEnum;
import com.charles445.simpledifficulty.api.thirst.ThirstEnumBlockPos;
import com.charles445.simpledifficulty.api.thirst.ThirstUtil;
import com.charles445.simpledifficulty.config.ModConfig;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class ThirstUtilInternal
implements IThirstUtil {
    @Nullable
    public static ThirstEnumBlockPos traceWaterToDrink(EntityPlayer player) {
        IThirstCapability capability;
        if (player.func_184614_ca().func_190926_b() && (capability = SDCapabilities.getThirstData(player)).isThirsty()) {
            ThirstEnumBlockPos traceResult = ThirstUtil.traceWater(player);
            if (traceResult == null) {
                return null;
            }
            if (traceResult.thirstEnum == ThirstEnum.PURIFIED) {
                if (!ServerConfig.instance.getBoolean(ServerOptions.THIRST_DRINK_BLOCKS)) {
                    return null;
                }
                if (!ServerConfig.instance.getBoolean(ServerOptions.INFINITE_PURIFIED_WATER)) {
                    player.field_70170_p.func_175698_g(traceResult.pos);
                }
            } else {
                if (traceResult.thirstEnum == ThirstEnum.RAIN && !ServerConfig.instance.getBoolean(ServerOptions.THIRST_DRINK_RAIN)) {
                    return null;
                }
                if (traceResult.thirstEnum == ThirstEnum.NORMAL && !ServerConfig.instance.getBoolean(ServerOptions.THIRST_DRINK_BLOCKS)) {
                    return null;
                }
            }
            return traceResult;
        }
        return null;
    }

    @Override
    @Nullable
    public ThirstEnumBlockPos traceWater(EntityPlayer player) {
        if (player.field_70125_A < -75.0f && player.field_70170_p.func_175727_C(player.func_180425_c()) && player.field_70170_p.func_175678_i(player.func_180425_c()) && ServerConfig.instance.getBoolean(ServerOptions.THIRST_DRINK_RAIN)) {
            return new ThirstEnumBlockPos(ThirstEnum.RAIN, player.func_180425_c());
        }
        double reach = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e() * 0.5;
        Vec3d eyevec = player.func_174824_e(1.0f);
        Vec3d lookvec = player.func_70676_i(1.0f);
        Vec3d targetvec = eyevec.func_72441_c(lookvec.field_72450_a * reach, lookvec.field_72448_b * reach, lookvec.field_72449_c * reach);
        RayTraceResult trace = player.func_130014_f_().func_72901_a(eyevec, targetvec, true);
        if (trace == null || trace.field_72313_a != RayTraceResult.Type.BLOCK) {
            return null;
        }
        Block traceBlock = player.func_130014_f_().func_180495_p(trace.func_178782_a()).func_177230_c();
        if (traceBlock == Blocks.field_150355_j) {
            return new ThirstEnumBlockPos(ThirstEnum.NORMAL, trace.func_178782_a());
        }
        if (traceBlock == SDFluids.blockPurifiedWater) {
            return new ThirstEnumBlockPos(ThirstEnum.PURIFIED, trace.func_178782_a());
        }
        return null;
    }

    @Override
    public void takeDrink(EntityPlayer player, int thirst, float saturation, float dirtyChance) {
        if (!QuickConfig.isThirstEnabled()) {
            return;
        }
        IThirstCapability capability = SDCapabilities.getThirstData(player);
        if (capability.isThirsty()) {
            capability.addThirstLevel(thirst);
            capability.addThirstSaturation(saturation);
            if (dirtyChance != 0.0f && player.field_70170_p.field_73012_v.nextFloat() < dirtyChance) {
                player.func_70690_d(new PotionEffect(SDPotions.thirsty, 600));
                if (ModConfig.server.thirst.thirstParasites && player.field_70170_p.field_73012_v.nextDouble() < ModConfig.server.thirst.thirstParasitesChance) {
                    player.func_70690_d(new PotionEffect(SDPotions.parasites, ModConfig.server.thirst.thirstParasitesDuration));
                }
            }
        } else if (capability.getThirstSaturation() < saturation) {
            capability.setThirstSaturation(saturation);
        }
    }

    @Override
    public void takeDrink(EntityPlayer player, int thirst, float saturation) {
        this.takeDrink(player, thirst, saturation, 0.0f);
    }

    @Override
    public void takeDrink(EntityPlayer player, ThirstEnum type) {
        this.takeDrink(player, type.getThirst(), type.getSaturation(), type.getThirstyChance());
    }

    @Override
    public ItemStack createPurifiedWaterBucket() {
        return FluidUtil.getFilledBucket((FluidStack)new FluidStack(SDFluids.purifiedWater, 1000));
    }
}

